function [ Frc ] = HW2CalibFrc(H,Nr,Np )
%Moves the robot to multiple poses, finds head holder, then solves AXXB
% 
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

Alist = H.PositionRobotAndFindMarkers(Frame(RotMx.eye(),vct3(500,500,500)));
Mlist = Alist - mean(Alist);
H.LastMlist = Mlist;
if Nr==1
    RList=[RotMx.eye()];  
else
    RList=[];
    for i=1:Nr
        di = -30+(i-1)*60/(Nr-1); 
        for j=1:Nr
            dj = -30+(j-1)*60/(Nr-1); 
            for k=0:(Nr-1)
                dk = -30+(k-1)*60/(Nr-1); 
                RList=[RList;RotMx.xyzD(di,dj,dk)];
            end
        end
    end
end

if Np==1
    pList=vct3Array(vct3(0,0,0));
else
    pList=vct3Array();
    n=0;
    for i=1:Np
        di = 300+(i-1)*400/(Np-1); 
        for j=1:Np
            dj = 300+(j-1)*400/(Np-1); 
            for k=1:Np
                dk = 400+(k-1)*600/(Np-1);
                n=n+1;pList(n)=vct3(di,dj,dk);
            end
        end
    end

end

FrobList=[]; FchList=[];
for i=1:size(RList,1)
    for j = 1:pList.NumEl()
        Ri = RList(i);
        pj = pList(j);
        Frob = Frame(Ri,pj);
        Fch  = HW2FindHeadHolder(H,Mlist,Frob);
        FrobList = [FrobList;Frob];
        FchList  = [FchList;Fch];
    end 
end

N = size(FrobList,1);
FaList=[]; FbList=[];
for k=2:N
    Fa = FrobList(1).Inverse()*FrobList(k);
    Fb = FchList(1)*FchList(k).Inverse();
    FaList = [FaList;Fa];
    FbList = [FbList;Fb];
end
H.LastFrobList = FrobList;
H.LastFchList  = FchList;
H.LastFaList   = FaList;
H.LastFbList   = FbList;
Frc = FrameAXXB(FaList,FbList);
end

